local assets=
{
	Asset("ANIM", "anim/DMaxe.zip"),
	Asset("ANIM", "anim/swap_DMaxe.zip"),
	
	Asset("IMAGE", "images/DMaxe.tex"),
	Asset("ATLAS", "images/DMaxe.xml"),
}

--local function onfinished(inst)
--    inst:Remove()
--end

local function onAttack(inst,holder,target)
	if target.EEmobexchanged and target.EEmobexchanged == true then
		holder.components.health.currenthealth = holder.components.health.currenthealth - 10
		holder.components.health:DoDelta(0,nil,"EM Multitool")
		holder.components.sanity:DoDelta(-25)
	end
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_DMaxe", "swap_axe")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("axe")
    anim:SetBuild("DMaxe")
    anim:PlayAnimation("idle")
    
    inst:AddTag("sharp")
    
    inst:AddComponent("weapon")
	if EEDEBUG == true then
		inst.components.weapon:SetDamage(10000)
	else
		inst.components.weapon:SetDamage(100)
	end
	inst.components.weapon:SetOnAttack(onAttack)
	
    -----
    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP, 2)
	
    -------
    
    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "DMaxe"
    inst.components.inventoryitem.atlasname = "images/DMaxe.xml"
    inst.components.inventoryitem:GetImage()
    inst.components.inventoryitem:GetAtlas()
    
    inst:AddComponent("equippable")

    inst.components.equippable:SetOnEquip( onequip )
    
    inst.components.equippable:SetOnUnequip( onunequip)

    
    return inst

end

return Prefab( "common/inventory/dmaxe", fn, assets)

